-- elements that are shared between the ScreenEditSpeedMods variants.
-- I really don't like repeating myself.

local menuState = {
	Mode = "Main",		-- menu mode. ("Main", "Edit")
	SubMode = nil,		-- sub mode ("Add","Edit","Delete")

	CurIndex = 1,		-- index in main menu
	ListIndex = 1,		-- index in sub menu (Speed Mod List)

	InputIndex = nil,	-- index in speed mod editor. (mod type)
	SpeedModType = nil, -- speed mod type ("X","C","M")
	NumpadX = 1,		-- numpad column
	NumpadY = 1,		-- numpad row
}

local mainStates = { "Main", "Edit" } -- Main=top 3, Edit=Edit pad
local subItems = { "Add", "Edit", "Delete" }

return Def.ActorFrame{
	Def.Actor{
		Name="InputController";
		MenuInputMessageCommand=function(self,param)
			local curMode = menuState.Mode
			local subMode = menuState.SubMode
			if param.Input == "Start" then
				-- handle mode switching
				if curMode == "Main" then
					if subMode == nil then
						local curIndex = menuState.CurIndex
						menuState.SubMode = subItems[curIndex]
						subMode = menuState.SubMode
						if subMode == "Add" then
							menuState.Mode = "Edit"
							MESSAGEMAN:Broadcast("AddSpeedMod",{MenuState = menuState})
						elseif subMode == "Edit" then
							menuState.Mode = "Edit"
							MESSAGEMAN:Broadcast("EditSpeedMod",{MenuState = menuState})
						elseif subMode == "Delete" then
							-- ask if they want to delete the speed mod, unless it's 1x
							MESSAGEMAN:Broadcast("DeleteSpeedMod",{MenuState = menuState})
						end
					else
						-- pass start to other
					end
				elseif curMode == "Edit" then
					-- start on edit mode depends on the submode; we want the
					-- modPad to handle this.
				end
			elseif param.Input == "Back" then
				if curMode == "Main" and subMode == nil then
					SCREENMAN:GetTopScreen():Cancel()
				else
					-- tell whatever's active to back off
					menuState.Mode = "Main"
					menuState.SubMode = nil
					--MESSAGEMAN:Broadcast("NewState",nil)
				end
			else
				if subMode == nil then
					-- main input
					if param.Input == "Left" then
						local idx = menuState.CurIndex
						local oldIdx = idx
						if idx - 1 < 1 then
							idx = #subItems
						else
							idx = idx - 1
						end
						MESSAGEMAN:Broadcast("MainMenuMove",{ New=idx, Old=oldIdx })
						menuState.CurIndex = idx
					elseif param.Input == "Right" then
						local idx = menuState.CurIndex
						local oldIdx = idx
						if idx + 1 > #subItems then
							idx = 1
						else
							idx = idx + 1
						end
						MESSAGEMAN:Broadcast("MainMenuMove",{ New=idx, Old=oldIdx })
						menuState.CurIndex = idx
					elseif param.Input == "Up" then
						MESSAGEMAN:Broadcast("ListInput",{ Index = menuState.ListIndex, Dir = "Up" })
					elseif param.Input == "Down" then
						MESSAGEMAN:Broadcast("ListInput",{ Index = menuState.ListIndex, Dir = "Down" })
					end
				else
					if curMode == "Edit" then
						if menuState.SpeedModType == nil then
							-- need to pick speed mod type
						else
							
						end
					else
						-- non-start input for a different mode
					end
				end
			end
		end;
		MenuUpP1MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_1, Input = "Up", }); end;
		MenuUpP2MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_2, Input = "Up", }); end;
		MenuDownP1MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_1, Input = "Down", }); end;
		MenuDownP2MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_2, Input = "Down", }); end;
		MenuLeftP1MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_1, Input = "Left", }); end;
		MenuLeftP2MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_2, Input = "Left", }); end;
		MenuRightP1MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_1, Input = "Right", }); end;
		MenuRightP2MessageCommand=function(self) MESSAGEMAN:Broadcast("MenuInput", { Player = PLAYER_2, Input = "Right", }); end;
		CodeMessageCommand=function(self,param)
			MESSAGEMAN:Broadcast("MenuInput", { Player = param.PlayerNumber, Input = param.Name })
		end;
		-- otherworld input:
		ListIndexMessageCommand=function(self,p) menuState.ListIndex = p.New; end;
	};

	LoadActor("mainButtons");	-- Add, Edit, and Delete buttons
	LoadActor("modPad");		-- speed mod edit pad

	-- instructions text
	LoadFont("_francophilsans Bold 24px")..{
		InitCommand=cmd(xy,SCREEN_CENTER_X+46,SCREEN_CENTER_Y+156;shadowlength,1;zoom,16/24);
		BeginCommand=cmd(settext,"&LEFT;&RIGHT; Changes Option / &UP;&DOWN; Changes Speed Mod");
	};
};